import OpenAI from 'openai';
import { env } from '../config/env.js';

export const openai = new OpenAI({
  apiKey: env.openaiApiKey,
});

export async function testChatGPTConnection(): Promise<boolean> {
  try {
    const response = await openai.chat.completions.create({
      model: env.openaiModel,
      messages: [{ role: 'user', content: 'Hello' }],
      max_tokens: 10,
    });

    console.log('✅ ChatGPT 연결 성공!');
    console.log(`Model: ${response.model}`);
    return true;
  } catch (error) {
    console.error('❌ ChatGPT 연결 실패:', error);
    return false;
  }
}
