import 'dotenv/config';

export const env = {
  // Stripe
  stripeSecretKey: process.env.STRIPE_SECRET_KEY,

  // OpenAI
  openaiApiKey: process.env.OPENAI_API_KEY,
  openaiModel: process.env.OPENAI_MODEL || 'gpt-3.5-turbo',
  openaiMaxTokens: parseInt(process.env.OPENAI_MAX_TOKENS || '1000'),
  openaiTemperature: parseFloat(process.env.OPENAI_TEMPERATURE || '0.7'),

  // General
  nodeEnv: process.env.NODE_ENV || 'development',
} as const;

// 환경 변수 검증
function validateEnv() {
  const required = {
    'STRIPE_SECRET_KEY': env.stripeSecretKey,
    'OPENAI_API_KEY': env.openaiApiKey,
  };

  const missing = Object.entries(required)
    .filter(([_, value]) => !value)
    .map(([key]) => key);

  if (missing.length > 0) {
    throw new Error(
      `필수 환경 변수가 설정되지 않았습니다: ${missing.join(', ')}\n` +
        '.env 파일을 확인해주세요.'
    );
  }
}

validateEnv();
