import chalk from 'chalk';
import { stripe } from './stripe/client.js';
import { randomAmount, randomProduct, randomCustomer } from './utils/random.js';

async function createRandomPayment() {
  const product = randomProduct();
  const customer = randomCustomer();
  const amount = randomAmount(10, 1000);

  const stripeCustomer = await stripe.customers.create({
    name: customer.name,
    email: customer.email,
  });

  const paymentIntent = await stripe.paymentIntents.create({
    amount,
    currency: 'usd',
    customer: stripeCustomer.id,
    description: product,
    confirm: true,
    payment_method: 'pm_card_visa',
    return_url: 'https://example.com/return',
  });

  console.log(chalk.green(`✅ 결제 생성 완료: ${paymentIntent.id}`));
  console.log(`   고객: ${customer.name}`);
  console.log(`   상품: ${product}`);
  console.log(`   금액: $${(amount / 100).toFixed(2)}`);

  return paymentIntent;
}

async function main() {
  const count = parseInt(process.argv[2] || '5');

  console.log(chalk.bold.cyan(`\n💳 ${count}건의 테스트 결제 생성\n`));

  for (let i = 1; i <= count; i++) {
    try {
      console.log(chalk.gray(`\n[${i}/${count}]`));
      await createRandomPayment();

      if (i < count) {
        await new Promise((resolve) => setTimeout(resolve, 500));
      }
    } catch (error) {
      console.error(chalk.red(`❌ 에러: ${error}`));
    }
  }

  console.log(chalk.bold.green(`\n\n✨ 완료! ${count}건의 결제가 생성되었습니다.\n`));
  console.log(chalk.gray('다음 명령어로 분석하세요: npm run analyze\n'));
}

main();
