import Stripe from 'stripe';
import { env } from '../config/env.js';

export const stripe = new Stripe(env.stripeSecretKey!, {
  apiVersion: '2024-11-20.acacia',
  typescript: true,
});

export async function testStripeConnection(): Promise<boolean> {
  try {
    const account = await stripe.accounts.retrieve();
    console.log('✅ Stripe 연결 성공!');
    console.log(`Account ID: ${account.id}`);
    return true;
  } catch (error) {
    console.error('❌ Stripe 연결 실패:', error);
    return false;
  }
}
