import { env } from './config/env.js';

console.log('🔍 환경 변수 확인\n');

console.log('Stripe API Key:', env.stripeSecretKey ? '✅ 설정됨' : '❌ 없음');
console.log('OpenAI API Key:', env.openaiApiKey ? '✅ 설정됨' : '❌ 없음');
console.log('환경:', env.nodeEnv);
console.log('모델:', env.openaiModel);

if (env.stripeSecretKey && env.openaiApiKey) {
  console.log('\n✨ 모든 설정이 완료되었습니다!');
  console.log('\n다음 단계:');
  console.log('1. npm run generate  - 테스트 결제 생성');
  console.log('2. npm run analyze   - 매출 분석');
} else {
  console.log('\n⚠️  .env 파일에 API 키를 설정해주세요.');
}
