export function randomInt(min: number, max: number): number {
  return Math.floor(Math.random() * (max - min + 1)) + min;
}

export function randomChoice<T>(array: T[]): T {
  return array[randomInt(0, array.length - 1)];
}

export function randomAmount(min: number = 10, max: number = 1000): number {
  return randomInt(min, max) * 100; // 센트로 변환
}

const PRODUCTS = [
  'Wireless Headphones',
  'Smart Watch',
  'Laptop Stand',
  'Mechanical Keyboard',
  'USB-C Cable',
  'Phone Case',
  'Coffee Maker',
  'Desk Lamp',
];

export function randomProduct(): string {
  return randomChoice(PRODUCTS);
}

const FIRST_NAMES = ['John', 'Jane', 'Mike', 'Sarah', 'David', 'Emily'];
const LAST_NAMES = ['Smith', 'Johnson', 'Brown', 'Davis', 'Wilson'];

export function randomCustomer(): { name: string; email: string } {
  const firstName = randomChoice(FIRST_NAMES);
  const lastName = randomChoice(LAST_NAMES);
  const name = `${firstName} ${lastName}`;
  const email = `${firstName.toLowerCase()}.${lastName.toLowerCase()}${randomInt(1, 999)}@example.com`;

  return { name, email };
}
